' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class CreateAppointment
  Inherits System.Web.UI.Page

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    ' Zmie tytul strony
    Me.Title = AppConfiguration.BookingObjectNameSingular & " - Kreator rezerwacji"
    If Not Page.IsPostBack Then
      ' Zawsze zaczynaj na pierwszej stronie kreatora
      wizAppointment.ActiveStepIndex = 0
      If Request.QueryString.Get("BookingObjectId") IsNot Nothing Then
        ' Jeli do tej stony przesano paramatery, wstpnie wybierz kontrolki na stronach kratora.
        lstBookingObject.SelectedIndex = -1
        lstBookingObject.DataBind()
        lstBookingObject.Items.FindByValue(Request.QueryString.Get("BookingObjectId")).Selected = True
        calStartDate.SelectedDate = Convert.ToDateTime(Request.QueryString.Get("SelectedDate"))
        hpTime.SelectedHour = Convert.ToInt32(Request.QueryString.Get("StartTime"))
        ' Przejd do wyboru czasu (trwania)
        wizAppointment.ActiveStepIndex = 3
      End If
    End If
    ' Ustaw tytu odnonika z obiektem rezerwacji
    wizAppointment.WizardSteps(1).Title = "Wybierz obiekt: " & AppConfiguration.BookingObjectNameSingular
    reqBookingObject.ErrorMessage = "Prosz wybra obiekt " & AppConfiguration.BookingObjectNameSingular
  End Sub

  Protected Sub wizAppointment_ActiveStepChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles wizAppointment.ActiveStepChanged
    Select Case wizAppointment.ActiveStepIndex
      Case 4
        ' Etap komentarza. Sprawd czy musimy wlaczy RequiredFieldValidator dla komentarza.
        reqComments.Enabled = AppConfiguration.RequireCommentsInRequest
      Case 5
        ' Ostatni krok, sprawd poprawno wszystkich stron.
        If ValidateAllSteps() Then
          Dim startDate As DateTime = calStartDate.SelectedDate.AddHours(hpTime.SelectedHour)
          Dim endDate As DateTime = startDate.AddHours(Convert.ToInt32(lstDuration.SelectedValue))
          lblBookingObject.Text = lstBookingObject.SelectedItem.Text
          lblStartTime.Text = startDate.ToString()
          lblEndTime.Text = endDate.ToString()
          lstDuration.Text = lstDuration.SelectedValue
          lblComments.Text = txtComments.Text
        End If
    End Select
  End Sub

  Protected Sub wizAppointment_NextButtonClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles wizAppointment.NextButtonClick
    ' Sprawd poprawno poszczeglnych krokw.
    ' Zauwa, e nie musimy sprawdza kroku 3, poniewa domylnie pierwsza z dwu pozycji
    ' w kontrolkach DropDownList bdzie wybrana.
    Select Case e.CurrentStepIndex
      Case 1
        If Not ValidateStep(1) Then
          e.Cancel = True
        End If
      Case 2
        If Not ValidateStep(2) Then
          e.Cancel = True
        End If
      Case 4
        If Not ValidateStep(4) Then
          e.Cancel = True
        End If
    End Select
  End Sub

  Protected Sub wizAppointment_FinishButtonClick(ByVal sender As Object, _
          ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles wizAppointment.FinishButtonClick
    Page.Validate()
    If Page.IsValid Then

      If ValidateAllSteps() Then
        ' Wszystkie kroki poprawne. Utwrz egzemplarz klasy Appointment, sprawd, czy mona dokonc rezerwacji, a jeli tak - dokonaj jej.
        wizAppointment.Visible = False

        Dim myAppointment As New Appointment()
        myAppointment.StartDate = _
            calStartDate.SelectedDate.AddHours(hpTime.SelectedHour)
        myAppointment.EndDate = _
            myAppointment.StartDate.AddHours(Convert.ToInt32( _
                lstDuration.SelectedValue))
        myAppointment.BookingObjectId = _
            Convert.ToInt32(lstBookingObject.SelectedValue)
        myAppointment.Comments = _
            Server.HtmlEncode(txtComments.Text)
        Dim myUser As MembershipUser = Membership.GetUser()
        myAppointment.UserName = myUser.UserName
        myAppointment.UserEmailAddress = myUser.Email

        If AppointmentManager.CheckAppointment(myAppointment) Then
          ' Mona dokona rezerwacji, wic zrb to
          AppointmentManager.CreateAppointment(myAppointment)
          MultiView1.ActiveViewIndex = 0
        Else
          ' Poinformuj uytkownika, e rezerwacji nie mona byo dokona.
          MultiView1.ActiveViewIndex = 1
        End If
      End If
    End If
  End Sub

  Protected Sub calStartDate_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles calStartDate.SelectionChanged
    ' Sprawd poprawno danej daty i zaktualizuj interfejs uytkownika.
    If Not IsStartDateValid() Then
      valStartDate2.IsValid = False
      litSelectedDate.Text = ""
    Else
      litSelectedDate.Text = String.Format("Wybrana data: {2}-{0}-{1}", calStartDate.SelectedDate.Month, calStartDate.SelectedDate.Day, calStartDate.SelectedDate.Year)
    End If
  End Sub

  Protected Sub lnkTryAgain_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkTryAgain.Click
    ' Poka znowu kreatora, na etapie 2 (o indeksie 1)
    wizAppointment.Visible = True
    wizAppointment.ActiveStepIndex = 1
    MultiView1.ActiveViewIndex = -1
  End Sub

#Region "Metody sprawdzania poprawnoci"

  Private Function IsStartDateValid() As Boolean
    ' Sprawd czy rezerwacja ma miejsce w przeszoci
    If calStartDate.SelectedDate.CompareTo(DateTime.Now.Date) < 0 Then
      Return False
    Else
      Return True
    End If
  End Function

  Private Function ValidateAllSteps() As Boolean
    Return ValidateStep(1) AndAlso ValidateStep(2) AndAlso ValidateStep(4)
  End Function

  Private Function ValidateStep(ByVal stepIndex As Integer) As Boolean
    Select Case stepIndex
      Case 1
        ' Krok 2 (o indeksie 1)
        If lstBookingObject.SelectedItem Is Nothing Then
          reqBookingObject.IsValid = False
          wizAppointment.ActiveStepIndex = 1
          Return False
        End If
      Case 2
        ' Krok 3 (o indeksie 2)
        If calStartDate.SelectedDate = DateTime.MinValue Then
          valStartDate1.IsValid = False
          wizAppointment.ActiveStepIndex = 2
          Return False
        Else
          If calStartDate.SelectedDate.CompareTo(DateTime.Now.Date) < 0 Then
            valStartDate2.IsValid = False
            wizAppointment.ActiveStepIndex = 2
            Return False
          End If
        End If
      Case 4
        ' Krok 5 (o indeksie 4)
        If AppConfiguration.RequireCommentsInRequest AndAlso _
              txtComments.Text.Length = 0 Then
          reqComments.IsValid = False
          wizAppointment.ActiveStepIndex = 4
          Return False
        End If
    End Select
    Return True
  End Function
#End Region

End Class
